//
//  SingleComponentPickerViewController.m
//  Pickers
//
//  Created by Robert Górczyński on 11-06-22.
//

#import "SingleComponentPickerViewController.h"


@implementation SingleComponentPickerViewController
@synthesize singlePicker; 
@synthesize pickerData; 

- (IBAction)buttonPressed { 
    NSInteger row = [singlePicker selectedRowInComponent:0]; 
    NSString *selected = [pickerData objectAtIndex:row]; 
    NSString *title = [[NSString alloc] initWithFormat: 
                       @"Wybrałeś %@!", selected]; 
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title 
													message:@"Dziękujemy za wybór." 
												   delegate:nil 
										  cancelButtonTitle:@"Nie ma za co" 
										  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
    [title release]; 
} 

- (void)viewDidLoad { 
    NSArray *array = [[NSArray alloc] initWithObjects:@"Luke", @"Leia", 
					  @"Han", @"Chewbacca", @"Artoo", @"Threepio", @"Lando", nil]; 
    self.pickerData = array; 
    [array release]; 
} 

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.singlePicker = nil; 
    self.pickerData = nil; 
}


- (void)dealloc {
	[singlePicker release]; 
    [pickerData release]; 
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych dla kontrolki Picker
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView { 
    return 1; 
} 

- (NSInteger)pickerView:(UIPickerView *)pickerView 
numberOfRowsInComponent:(NSInteger)component { 
    return [pickerData count]; 
} 

#pragma mark Metody delegata kontrolki Picker
- (NSString *)pickerView:(UIPickerView *)pickerView 
			 titleForRow:(NSInteger)row 
			forComponent:(NSInteger)component { 
    return [pickerData objectAtIndex:row]; 
} 

@end
